% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerful.maxeig.tri.R
\name{powerful.maxeig.tri}
\alias{powerful.maxeig.tri}
\title{Tridiagonal matrix maximal eigenpair}
\usage{
powerful.maxeig.tri(a, b, C, digit.thresh = 6)
}
\arguments{
\item{a}{The lower diagonal vector.}

\item{b}{The upper diagonal vector.}

\item{C}{The main diagonal vector.}

\item{digit.thresh}{The precise level of output results.}
}
\value{
A list of eigenpair object are returned, with components \eqn{z}, \eqn{v} and \eqn{iter}.
\item{z}{The approximating sequence of the maximal eigenvalue.}
\item{v}{The approximating eigenfunction of the corresponding eigenvector.}
\item{iter}{The number of iterations.}
}
\description{
Calculate the maximal eigenpair for the tridiagonal matrix by
Thomas algorithm.
}
\examples{
nn = 8
a = c(1:(nn - 1))^2
b = c(1:(nn - 1))^2
C = c(b[1], a[1:(nn - 2)] + b[2:(nn - 1)], a[nn - 1] + nn^2)
powerful.maxeig.tri(a, b, C, digit.thresh = 6)
}
