% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{matern.kernel}
\alias{matern.kernel}
\title{Matern kernel}
\usage{
matern.kernel(u, rho, kappa)
}
\arguments{
\item{u}{a vector, matrix or array with values of the distances between pairs of data locations.}

\item{rho}{value of the (re-parametrized) scale parameter; this corresponds to the re-parametrization \code{rho = 2*sqrt(kappa)*phi}.}

\item{kappa}{value of the shape parameter.}
}
\value{
A vector matrix or array, according to the argument u, with the values of the Matern kernel function for the given distances.
}
\description{
This function computes values of the Matern kernel for given distances and parameters.
}
\details{
The Matern kernel is defined as:
\deqn{
K(u; \phi, \kappa) = \frac{\Gamma(\kappa + 1)^{1/2}\kappa^{(\kappa+1)/4}u^{(\kappa-1)/2}}{\pi^{1/2}\Gamma((\kappa+1)/2)\Gamma(\kappa)^{1/2}(2\kappa^{1/2}\phi)^{(\kappa+1)/2}}\mathcal{K}_{\kappa}(u/\phi), u > 0,
}
where \eqn{\phi} and \eqn{\kappa} are the scale and shape parameters, respectively, and \eqn{\mathcal{K}_{\kappa}(.)} is the modified Bessel function of the third kind of order \eqn{\kappa}. The family is valid for \eqn{\phi > 0} and \eqn{\kappa > 0}.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

