% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{data_selecting}
\alias{data_selecting}
\title{Selecting products from the user's data set for further price index calculations}
\usage{
data_selecting(
  data,
  include = c(),
  must = c(),
  exclude = c(),
  sensitivity = TRUE,
  coicop = NULL
)
}
\arguments{
\item{data}{The user's data frame. It must contain a column \code{description} (as character).}

\item{include}{A vector consisting of words and phrases. The function reduces the data set to one in which the \code{description} column contains any of these values.}

\item{must}{A vector consisting of words and phrases. The function reduces the data set to one in which the \code{description} column contains each of these values.}

\item{exclude}{A vector consisting of words and phrases. The function reduces the data set to one in which the \code{description} column does not contain any of these values.}

\item{sensitivity}{A logical parameter indicating whether sensitivity to lowercase and uppercase letters is taken into consideration (if yes, its value is TRUE).}

\item{coicop}{An optional parameter indicating a value for an additional column \code{coicop} which is added to the resulting data frame}
}
\value{
The function returns a subset of the user's data set obtained by selection based on keywords and phrases defined by parameters: \code{include}, \code{must} and \code{exclude} (an additional column \code{coicop} is optional). Providing values of these parameters, please remember that the procedure distinguishes between uppercase and lowercase letters only when \code{sensitivity} is set to TRUE.
}
\description{
The function returns a subset of the user's data set obtained by selection based on keywords and phrases.
}
\examples{
data_selecting(milk, include=c("milk"), must=c("UHT"))
data_selecting(milk, must=c("milk"), exclude=c("paust"))
}
