% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_new.R
\name{sales_groups2}
\alias{sales_groups2}
\title{Providing information about sales of products}
\usage{
sales_groups2(
  data = data.frame(),
  by,
  start,
  end,
  shares = FALSE,
  barplot = FALSE,
  names = c()
)
}
\arguments{
\item{data}{The user's data frame with subgroups of sold products (see \code{by} parameter). The data frame must contain columns: \code{time} (as Date in format: year-month-day, e.g. '2020-12-01'), \code{prices} (as positive numeric) and \code{quantities} (as positive numeric). An additional column indicated via \code{by} parameter is also needed.}

\item{by}{The column name indicating grouping variable, i.e. this column is used for creating subgroups of products.}

\item{start}{The beginning of the considered time interval (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The end of the considered time interval (as character) limited to the year and month, e.g. "2020-04".}

\item{shares}{A logical parameter indicating whether the function is to calculate shares of product sales}

\item{barplot}{A logical parameter indicating whether the function is to return barplot for product sales.}

\item{names}{A vector of characters describing product groups defined by \code{datasets}.}
}
\value{
The function returns values of sales of products or the corresponding barplot for these sales (if \code{barplot} is TRUE). Alternatively, it calculates the sale shares (if \code{shares} is TRUE).
}
\description{
The function returns values of sales of products or the corresponding barplot for these sales.
}
\examples{
\donttest{outlets<-as.character(unique(milk$retID))}
\donttest{sales_groups2(milk,by="retID",start="2019-04",end="2019-04",
shares=TRUE,barplot=TRUE,names=outlets)}
}
