% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drsim.R
\name{drsim}
\alias{drsim}
\title{drsim}
\usage{
drsim(r.mat, p.mat, top = 0.005, r.thres = 0.7, p.thres = 0.01)
}
\arguments{
\item{r.mat}{The input matrix of drug correlations.}

\item{p.mat}{The input matrix of probability values(p-value) of drug correlations.}

\item{top}{A value to measure drug similarity. It's a threshold of correlation, top=0.005(default) means that top 0.005 of drugs for each row are considered as strong similarity.}

\item{r.thres}{A value to measure drug similarity. It's a threshold of correlation, r.thres=0.7(default) means that the similarity between drugs are strong when r greater than 0.7.}

\item{p.thres}{A value to measure the significance level of drug similarity. It's a threshold of probability values, p.thres=0.01(default) means that the similarity between drugs are significant when p less than 0.01.}
}
\value{
A binary adjacency matrix of drug similarity.
}
\description{
This function is used to construct a binary adjacency matrix of drug similarity where 1 means strong similarity and 0 means weak similarity.
}
\examples{
r <- getData("drug.r")
fdr <- getData("drug.fdr")
m <- drsim(r, fdr, top = 0.5)
}
