% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_quarter_office_expenses_house_member.R
\name{get_quarter_office_expenses_house_member}
\alias{get_quarter_office_expenses_house_member}
\title{Get Quarterly Office Expenses by a Specific House Member}
\usage{
get_quarter_office_expenses_house_member(member_id, year, quarter,
  myAPI_Key)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.l}

\item{year}{2009-2017}

\item{quarter}{1,2,3,4}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
the amount a given lawmaker spent during a specified year and quarter by category,
}
\description{
The House of Representatives publishes quarterly reports detailing official office expenses by lawmakers. The Congress API has data beginning in the third quarter of 2009.  HTTP Request: GET https://api.propublica.org/congress/v1/members/{member-id}/office_expenses/{year}/{quarter}.json
}
\examples{
\donttest{
get_quarter_office_expenses_house_member('A000374', 2017, 4)
}
}
