% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_electronic_filing_byDate.R
\name{get_electronic_filing_byDate}
\alias{get_electronic_filing_byDate}
\title{Get Electronic Filings by Date}
\usage{
get_electronic_filing_byDate(
  cycle = 2018,
  year,
  month,
  day,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{cycle}{The election cycle}

\item{year}{The four-digit year from 2001-2016}

\item{month}{The two-digit month from 01-12}

\item{day}{The two-digit day from 01-31}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves information about FEC reports filed electronically on a specific date.
}
\description{
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/filings/{year}/{month}/{day}
}
\examples{
\dontrun{
get_electronic_filing_byDate(2016, 2016, '01', '10')
}
}
