% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro.sgpv.R
\name{coef.sgpv}
\alias{coef.sgpv}
\title{Extract coefficients from the model fit}
\usage{
\method{coef}{sgpv}(object, ...)
}
\arguments{
\item{object}{An \code{sgpv} object}

\item{...}{Other \code{coef} arguments}
}
\value{
Coefficients in the OLS model
}
\description{
S3 method \code{coef} for an S3 object of class \code{sgpv}
}
\examples{

# load the package
library(ProSGPV)

# prepare the data
x <- t.housing[, -ncol(t.housing)]
y <- t.housing$V9

# run one-stage algorithm
out.sgpv.1 <- pro.sgpv(x = x, y = y, stage = 1)

# get coefficients
coef(out.sgpv.1)
}
