% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/02PTCell.r
\docType{methods}
\name{octave}
\alias{octave}
\alias{octave,PTCell-method}
\alias{octave,numeric-method}
\alias{octave<-}
\alias{octave<-,PTCell,numeric-method}
\title{Extract or replace an octave}
\usage{
\S4method{octave}{numeric}(x)

\S4method{octave}{PTCell}(x)

\S4method{octave}{PTCell,numeric}(x) <- value
}
\arguments{
\item{x}{Either a (\code{vector} of) numeric value(s), representing a period
value. It can also be a \code{\link{PTCell}} object.}

\item{value}{A \code{numeric} value representing the octave number with which
that of object \code{x} needs to be replaced. 0, 1 and 3 are valid octave
numbers. Use zero to disable both the note and octave for object \code{x}.

Note that the octave can only be set for \code{\link{PTCell}}s for which
a note is already defined.}
}
\value{
For \code{octave}, a \code{numeric} value representing the octave number
is returned.

For \code{octave<-}, a copy of \code{PTCell} object \code{x} in which the
octave number is replaced by \code{value} is returned.
}
\description{
Obtain an octave number from a period value or extract or replace a
note of a \code{\link{PTCell}} object.
}
\details{
Period values are used by ProTracker to set a playback sample rate
and in essence determine the key and octave in which a sound is played.
This method can be used to obtain the octave number associated with a
period value (according to the ProTracker \code{\link{period_table}},
assuming zero \code{\link{fineTune}}). If the period value is not in the
\code{\link{period_table}}, the octave number associated with the
period closest to this value in the table is returned.

The octave number can also be obtained or replaced for a
\code{\link{PTCell}} object.
}
\examples{
data("mod.intro")

## get the octave number of PTCell at pattern #3, track #2,
## row #1 from mod.intro (which is number 3):

octave(PTCell(mod.intro, 1, 2, 3))

## replace the octave number of PTCell at pattern #3, track #2,
## row #1 from mod.intro with 2:

octave(PTCell(mod.intro, 1, 2, 3)) <- 2

## get the octave numbers associated with the period
## values 200 up to 400:

octave(200:400)
}
\author{
Pepijn de Vries
}
\seealso{
Other note.and.octave.operations: \code{\link{noteDown}},
  \code{\link{noteDown,PTCell-method}},
  \code{\link{noteDown,PTPattern-method}},
  \code{\link{noteDown,PTTrack-method}},
  \code{\link{noteUp}}, \code{\link{noteUp,PTCell-method}},
  \code{\link{noteUp,PTPattern-method}},
  \code{\link{noteUp,PTTrack-method}},
  \code{\link{octaveDown}},
  \code{\link{octaveDown,PTCell-method}},
  \code{\link{octaveDown,PTPattern-method}},
  \code{\link{octaveDown,PTTrack-method}},
  \code{\link{octaveUp}},
  \code{\link{octaveUp,PTCell-method}},
  \code{\link{octaveUp,PTPattern-method}},
  \code{\link{octaveUp,PTTrack-method}};
  \code{\link{noteToPeriod}};
  \code{\link{noteToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{sampleRate}}, \code{\link{sampleRate}};
  \code{\link{note}}, \code{\link{note,PTCell-method}},
  \code{\link{note,numeric-method}}, \code{\link{note<-}},
  \code{\link{note<-,PTCell,character-method}};
  \code{\link{periodToChar}}

Other period.operations: \code{\link{noteToPeriod}};
  \code{\link{noteToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{sampleRate}}, \code{\link{sampleRate}};
  \code{\link{note}}, \code{\link{note,PTCell-method}},
  \code{\link{note,numeric-method}}, \code{\link{note<-}},
  \code{\link{note<-,PTCell,character-method}};
  \code{\link{periodToChar}}; \code{\link{period_table}}
}

