% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{write.module}
\alias{write.module}
\alias{write.module,PTModule,ANY-method}
\alias{write.module,PTModule,character-method}
\title{Export an PTModule object as a ProTracker module file}
\usage{
\S4method{write.module}{PTModule,ANY}(mod, file)

\S4method{write.module}{PTModule,character}(mod, file)
}
\arguments{
\item{mod}{A valid PTModule object to be saved as a ProTracker *.mod file}

\item{file}{either a filename to write to, or a file connection, that
allows to write binary data (see \code{\link[base]{file}}).}
}
\value{
Writes to a module file but returns nothing.
}
\description{
Export an \code{\link{PTModule}} object as a ProTracker module file,
conform ProTracker 2.3A specifications.
}
\details{
The routine to write ProTracker modules is based on the referenced version
of ProTracker 2.3A. This means that the routine may not be able to
write files that ar compatible with later or earlier ProTracker versions.
}
\examples{
## get the PTModule object provided with the ProTrackR package
data("mod.intro")

## save the object as a valid ProTracker module file:
write.module(mod.intro, "intro.mod")

## or create the connection yourself:
con <- file("intro2.mod", "wb")
write.module(mod.intro, con)

## don't forget to close the connection after you're done:
close(con)
}
\author{
Pepijn de Vries
}
\references{
\url{http://wiki.multimedia.cx/index.php?title=Protracker_Module}

\url{http://coppershade.org/articles/More!/Topics/Protracker_File_Format/}
}
\seealso{
Other io.operations: \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}

Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{clearSamples}},
  \code{\link{clearSamples,PTModule-method}};
  \code{\link{clearSong}},
  \code{\link{clearSong,PTModule-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{modToWave}},
  \code{\link{modToWave,PTModule-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{playMod}},
  \code{\link{playMod,PTModule-method}};
  \code{\link{playingtable}},
  \code{\link{playingtable,PTModule-method}};
  \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{trackerFlag}},
  \code{\link{trackerFlag,PTModule-method}},
  \code{\link{trackerFlag<-}},
  \code{\link{trackerFlag<-,PTModule-method}}
}

