% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{rawToSignedInt}
\alias{rawToSignedInt}
\title{Convert a raw vector into signed integers (short)}
\usage{
rawToSignedInt(raw_dat)
}
\arguments{
\item{raw_dat}{A vector of \code{raw} data.}
}
\value{
A vector of the same length as \code{raw_dat}, holding signed integer values.
}
\description{
This function converts a vector of \code{raw} data into signed integer values.
}
\details{
This function converts a vector of \code{raw} data into signed integer values
[-128,127]. To convert unsigned integers into raw data use \code{\link{as.raw}(x)}.
For the inverse of this function see \code{\link{signedIntToRaw}(int_dat)}.
}
\examples{
## generate some raw data:
some.raw.data <- as.raw(c(0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x90))

## convert the raw data into a vector of signed intgers:
rawToSignedInt(some.raw.data)

}
\author{
Pepijn de Vries
}
\seealso{
Other integer.operations: \code{\link{nybbleToSignedInt}},
  \code{\link{nybble}}, \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}, \code{\link{waveform}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{nybbleToSignedInt}}, \code{\link{nybble}},
  \code{\link{rawToCharNull}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}
}

