% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02PTCell.r, R/03PTTrack.r, R/04PTPattern.r
\docType{methods}
\name{as.raw}
\alias{as.raw}
\alias{as.raw,PTCell-method}
\alias{as.raw<-}
\alias{as.raw<-,PTCell,raw-method}
\alias{as.raw,PTTrack-method}
\alias{as.raw<-,PTTrack,matrix-method}
\alias{as.raw,PTPattern-method}
\alias{as.raw<-,PTPattern,matrix-method}
\title{Extract and replace raw data}
\usage{
\S4method{as.raw}{PTCell}(x)

\S4method{as.raw}{PTCell,raw}(x) <- value

\S4method{as.raw}{PTTrack}(x)

\S4method{as.raw}{PTTrack,matrix}(x) <- value

\S4method{as.raw}{PTPattern}(x)

\S4method{as.raw}{PTPattern,matrix}(x) <- value
}
\arguments{
\item{x}{A \code{\link{PTCell}}, \code{\link{PTTrack}} or
\code{\link{PTPattern}} object, for which the raw data needs to extracted
or replaced.}

\item{value}{\code{raw} data with which the \code{raw} data in object
\code{x} needs to be replaced.

If \code{x} is a \code{PTCell} object, \code{value}
should be a \code{vector} of four \code{raw} values (conform specifications
provided at the documentation of the \code{\link{PTCell-class}}).

If \code{x} is a \code{PTTrack} object, \code{value}
should be a 64 by 4 \code{matrix} holding \code{raw} values (conform specifications
provided at the documentation of the \code{\link{PTTrack-class}}).

If \code{x} is a \code{PTPattern} object, \code{value}
should be a 64 by 16 \code{matrix} holding \code{raw} values (conform specifications
provided at the documentation of the \code{\link{PTPattern-class}}).}
}
\value{
For \code{as.raw}, a length 4 vector, 64 by 4 matrix or a 64 by 16
matrix of \code{raw} data is returned, when x is of class \code{PTCell},
\code{PTTrack} or \code{PTPattern}, respectively.

For \code{as.raw<-}, a copy of object \code{x} is returned in which the
\code{raw} data is replaced by \code{value}.
}
\description{
Information of \code{\link{PTCell}}, \code{\link{PTTrack}} and
\code{\link{PTPattern}} objects are stored as \code{raw} values. This
method can be used to extract and replace this raw data.
}
\details{
A \code{\link{PTCell}} is an element of a \code{\link{PTTrack}} which
in turn is an element of a \code{\link{PTPattern}}. A \code{\link{PTPattern}}
tells a tracker which sample to play at which frequency on which of the
four audio channels and with which effects. A \code{\link{PTCell}} in essence
holds all this information as described at the documentation of
the \code{\link{PTCell-class}}.

Data in these objects are stored in these objects in a \code{raw} form,
to save working memory and to comply to the ProTracker file specifications
(see documentation of each of these classes for more details). This method
can be used to extract and replace raw data.
}
\examples{
data("mod.intro")

## Get the raw data of the PTCell at
## pattern #1, track #1 and row #1
## of mod.intro:
as.raw(PTCell(mod.intro, 1, 1, 1))

## idem for PTTrack #1 of pattern #1:
as.raw(PTTrack(mod.intro, 1, 1))

## idem for PTPattern #1:
as.raw(PTPattern(mod.intro, 1))

## replace raw data of PTCell 1, 1, 1
## with that of PTCell 2, 1, 1:
as.raw(PTCell(mod.intro, 1, 1, 1)) <-
  as.raw(PTCell(mod.intro, 2, 1, 1))

}
\seealso{
Other raw.operations: \code{\link{nybbleToSignedInt}},
  \code{\link{nybble}}, \code{\link{rawToCharNull}},
  \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}
}
\author{
Pepijn de Vries
}
