% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{signedIntToNybble}
\alias{signedIntToNybble}
\title{Convert a signed integer to a nybble in raw data.}
\usage{
signedIntToNybble(int_dat, which = c("low", "high"))
}
\arguments{
\item{int_dat}{A single\code{intger} value or a \code{vector} of
\code{integer} data ranging from -8 up to 7.}

\item{which}{A character string indicating whether the nybble should
be set to the "\code{low}" (default) or "\code{high}" position of the
raw data that is returned.}
}
\value{
Returns \code{raw} data of the same length as \code{int_dat}.
The returned raw data holds either low or high nybbles (as specified
by \code{which}) based on the provided signed \code{integer}s.
}
\description{
This function converts a signed integer ranging from -8 up to 7 into
either the high or low nybble of a byte, represented by \code{raw} data.
}
\details{
Nybbles are 4 bit values, where each byte (8 bits) holds two nybbles.
A high nybble (left-hand side of a byte) and a low nybble (right-hand
side of a byte). This function converts a signed \code{integer} value
ranging from -8 up to 7 to a nybble and sets it as either a high or a low
nybble in \code{raw} data.
}
\examples{
## generate some integers in the right range:

dati <- sample(-8:7, 100, replace = TRUE)

## Set the low nybbles of rawl based on dati:

rawl <- signedIntToNybble(dati)

## Set the high nybbles of rawl based on dati:

rawh <- signedIntToNybble(dati, "high")
}
\seealso{
Other nybble.functions: \code{\link{nybbleToSignedInt}},
  \code{\link{nybble}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{nybbleToSignedInt}}, \code{\link{nybble}},
  \code{\link{rawToCharNull}},
  \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}

Other integer.operations: \code{\link{nybbleToSignedInt}},
  \code{\link{nybble}}, \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}, \code{\link{waveform}}
}
\author{
Pepijn de Vries
}
