% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{loopLength}
\alias{loopLength}
\alias{loopLength,PTSample-method}
\alias{loopLength<-}
\alias{loopLength<-,PTSample-method}
\title{The loop length of a PTSample}
\usage{
\S4method{loopLength}{PTSample}(sample)

\S4method{loopLength}{PTSample}(sample) <- value
}
\arguments{
\item{sample}{A \code{\link{PTSample}} for which the loop length
needs to be extracted or replace.}

\item{value}{An even \code{numeric} value giving the loop length in
samples ranging from 2 up to 131070 (It can be 0 when the sample is
empty). The sum of the \code{\link{loopStart}} and
\code{\link{loopLength}} should not exceed the \code{\link{sampleLength}}.

Use a \code{value} of either \code{character} "\code{off}" or \code{logical}
"\code{FALSE}", in order to turn off the loop all together.}
}
\value{
For \code{loopLength} the loop length (in samples), represented by
an even \code{integer} value ranging from 0 up to 131070, is returned.

For \code{loopLength<-} A \code{\link{PTSample}} \code{sample}, updated
with the loop length `\code{value}', is returned.
}
\description{
Extract or replace the loop length of a \code{\link{PTSample}}.
}
\details{
\code{\link{PTSample}}s can have loops, marked by a starting position
and length of the loop (in samples), for more details see the
\code{\link{PTSample-class}}. This method can be used to extract
the loop length or safely replace its value.
}
\examples{
data("mod.intro")

## get the loop length of the
## first sample of mod.intro:

loopLength(PTSample(mod.intro, 1))

## Let's change the length of
## the loop to 200

loopLength(PTSample(mod.intro, 1)) <- 200

## Let's turn off the loop all together:

loopLength(PTSample(mod.intro, 1)) <- FALSE

}
\seealso{
Other loop.methods: \code{\link{loopSample}},
  \code{\link{loopStart}}, \code{\link{loopState}}

Other sample.operations: \code{\link{PTSample-class}},
  \code{\link{PTSample-method}}, \code{\link{fineTune}},
  \code{\link{loopSample}}, \code{\link{loopStart}},
  \code{\link{loopState}}, \code{\link{name}},
  \code{\link{playSample}}, \code{\link{read.sample}},
  \code{\link{sampleLength}}, \code{\link{volume}},
  \code{\link{waveform}}, \code{\link{write.sample}}
}
\author{
Pepijn de Vries
}
