% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{class}
\name{PTModule-class}
\alias{PTModule-class}
\alias{PTModule}
\title{The PTModule class}
\description{
The PTModule class provides a container to store and modify and use ProTracker
module files.
}
\details{
MOD is a computer file format used primarily to represent music. A MOD file
contains a set of instruments in the form of samples, a number of patterns
indicating how and when the samples are to be played, and a list of what
patterns to play in what order. The simplified structure of a module class is
visualised in the scheme below. Details are given in the slot descriptions
below.

\if{html}{\figure{protrackerscheme.png}{ProTracker conceptual scheme}}
\if{latex}{\figure{protrackerscheme.pdf}{options: width=6in}}

This class is designed to hold all relevant information of a ProTracker
module (MOD) for which ProTracker 2.3a documentation was used. The ProTrackR
package may be compatible with earlier or later versions, but this was not
tested. Use \code{\link{read.module}} and \code{\link{write.module}} to import
and export objects of class \code{PTModule}.
}
\section{Slots}{

\describe{
\item{\code{name}}{A \code{vector} of length 20 of class "\code{raw}", representing
the name of the \code{PTModule}. The name
of a module can be extracted or replaced with the \code{\link{name}} method.}

\item{\code{pattern.order}}{A \code{vector} of length 128 of class "\code{raw}". The
\code{raw} values represent the indices of \code{PTPattern} tables and indicate
in which order these patterns need to be played. Note that the \code{raw} values
are conform the indices used in ProTracker, starting at zero. In R, indices of
objects start at one. Users need to compensate for this discrepancy theirselves.

The pattern order table can be extracted or replaced with the
\code{\link{patternOrder}} method.}

\item{\code{pattern.order.length}}{A single value of class "\code{raw}". Indicates
the length of the visible (and playable) part of the pattern order table.

Use the \code{\link{patternOrderLength}} method to extract or replace the length
of a pattern order table of a module.}

\item{\code{tracker.byte}}{A single "\code{raw}" value. Gives an indication of which
Tracker was used to produce a module file. In ProTracker modules, this byte
is set to 0x7f, which is also used in \code{PTModule} objects. This value
should not be changed.}

\item{\code{tracker.flag}}{A \code{vector} of length 4 of class "\code{raw}", indicates
the version of a module, which basically reflects how many patterns the module
can hold. For details, and extracting and replacing this flag see the
\code{\link{trackerFlag}} method.}

\item{\code{samples}}{List of length 31 of class "\code{\link{PTSample}}".}

\item{\code{patterns}}{List of class "\code{\link{PTPattern}}" (the pattern tables).
The list should have at least 1 element, and can have a maximum of 64 or
100 elements (depending on the state of the \code{\link{trackerFlag}}).}
}}

\examples{
## create an empty PTModule class object:
mod.empty <- new("PTModule")

## get an example PTModule class object
## provided with the ProTrackR package:
data("mod.intro")

}
\references{
\url{https://en.wikipedia.org/wiki/MOD_(file_format)}

\url{https://wiki.multimedia.cx/index.php?title=Protracker_Module}

\url{http://coppershade.org/articles/More!/Topics/Protracker_File_Format/}
}
\seealso{
Other module.operations: 
\code{\link{appendPattern}()},
\code{\link{clearSamples}()},
\code{\link{clearSong}()},
\code{\link{deletePattern}()},
\code{\link{fix.PTModule}()},
\code{\link{modToWave}()},
\code{\link{moduleSize}()},
\code{\link{patternLength}()},
\code{\link{patternOrderLength}()},
\code{\link{patternOrder}()},
\code{\link{playMod}()},
\code{\link{playingtable}()},
\code{\link{rawToPTModule}()},
\code{\link{read.module}()},
\code{\link{trackerFlag}()},
\code{\link{write.module}()}
}
\author{
Pepijn de Vries
}
\concept{module.operations}
