% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_manipulation.R
\name{combine_actions}
\alias{combine_actions}
\title{Combine consecutive actions into a single action}
\usage{
combine_actions(seqs, old_actions, new_action, timestamp = "first")
}
\arguments{
\item{seqs}{an object of class \code{"\link{proc}"}}

\item{old_actions}{a character vector giving consecutive actions to be replaced.}

\item{new_action}{a string giving the combined action}

\item{timestamp}{"first", "last", or "avg", specifying how the timestamp of the combined
action should be derived.}
}
\value{
an object of class \code{"\link{proc}"}
}
\description{
Combine the action pattern described in \code{old_actions} into a single action 
\code{new_action}. The timestamp of the combined action can be the timestamp of the
first action in the action pattern, the timestamp of the last action in the action
pattern, or the average of the two timestamps.
}
\examples{
seqs <- seq_gen(100)
new_seqs <- combine_actions(seqs, 
                            old_actions=c("OPT1_3", "OPT2_2", "RUN"), 
                            new_action="KEY_ACTION")
}
