% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_generator.R
\name{seq_gen}
\alias{seq_gen}
\title{Action sequence generator}
\usage{
seq_gen(n, action_set1 = c("OPT1_1", "OPT1_2", "OPT1_3"),
  action_set2 = c("OPT2_1", "OPT2_2"), answer_set = c("CHECK_A",
  "CHECK_B", "CHECK_C", "CHECK_D"), p1 = rep(1, length(action_set1)),
  p2 = rep(1, length(action_set2)), p_answer = rep(1,
  length(answer_set)), p_continue = 0.5, p_choose = 0.5,
  include_time = FALSE, time_intv_dist = list("exp", 1),
  seed = 12345)
}
\arguments{
\item{n}{An integer. The number of action sequences to be generated.}

\item{action_set1, action_set2}{Character vectors giving the choices for 
the first and the second conditions.}

\item{answer_set}{A character vector giving the choices for the answer.}

\item{p1, p2}{Nonnegative numeric vectors. They are the weights for sampling 
from \code{action_set1} and \code{action_set2}.}

\item{p_answer}{A nonnegative numeric vector giving the weights for sampling
from \code{answer_set}.}

\item{p_continue}{Probability of running an/another experiment.}

\item{p_choose}{Probability of choosing an answer.}

\item{include_time}{logical. Indicate if timestamp sequences should be generated. Default is
FALSE.}

\item{time_intv_dist}{A list specifying the distribution of the inter-arrival time.}

\item{seed}{Random seed.}
}
\value{
An object of class \code{"\link{proc}"} with \code{time_seqs = NULL}.
}
\description{
\code{seq_gen} generates action sequences of an imaginary simulation-based item.
}
\details{
The format of the generated sequences resembles that of the response processes of 
simulation-based items. In these items, participants are asked to answer
a question by running simulated experiments in which two conditions can 
be controlled. A simulated experiment can be run by setting the two conditions
at one of the given choices and click "Run" button.

The possible actions are "Start", "End", "Run", and the elements in \code{action_set1}, 
\code{action_set2}, and \code{answer_set}. The generated sequences begin with "Start"
and continue with groups of three actions. Each group of three actions, representing 
one experiment, consists of an action chosen from \code{action_set1} according to 
\code{p1}, an action chosen from \code{action_set2} according to \code{p2}, and "Run".
The probability of performing an experiment after "Start" or one experiment is 
\code{p_continue}. After the experiment process, with probability \code{p_choose}, an 
answer will be chosen. The chosen answer is randomly sampled from \code{answer_set} 
according to \code{p_answer}. All generated sequences end with "End".
}
\seealso{
Other sequence generators: \code{\link{seq_gen2}},
  \code{\link{seq_gen3}}
}
\concept{sequence generators}
