% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_generator.R
\name{seq_gen3}
\alias{seq_gen3}
\title{RNN action sequence generator}
\usage{
seq_gen3(n, events = letters, rnn_type = "lstm", K = 10,
  weights = NULL, max_len = 100, initial_state = NULL,
  start_index = 1, end_index = length(events), include_time = FALSE,
  time_intv_dist = list("exp", 1), gpu = FALSE, parallel = FALSE,
  seed = 12345)
}
\arguments{
\item{n}{An integer. The number of action sequences to be generated.}

\item{events}{A character vector specifying the set of \code{N} possible
actions. Default is \code{letters}.}

\item{rnn_type}{the type of recurrent unit to be used for generating sequences. 
\code{"lstm"} for the long-short term memory unit. \code{"gru"} for the gated
recurrent unit.}

\item{K}{the latent dimension of the recurrent unit.}

\item{weights}{a list containing the weights in the embedding layer, the recurrent 
unit, the fully connected layer. If not (properly) specified, randomly generated 
weights are used.}

\item{max_len}{Maximum length of generated sequences.}

\item{initial_state}{a list containing the initial state of the recurrent neural 
network. If \code{rnn_type="lstm"}, it contains two 1 by \code{K} matrices. If
\code{rnn_type="gru"}, it contains one 1 by \code{K} matrix. If not specified, 
all the elements are set to zero.}

\item{start_index}{Index of the action indicating the start of an item in
\code{events}.}

\item{end_index}{Index of the action indicating the end of an item in
\code{events}.}

\item{include_time}{logical. Indicate if timestamp sequences should be generated. Default is
FALSE.}

\item{time_intv_dist}{A list specifying the distribution of the inter-arrival time.}

\item{gpu}{logical. If TRUE, use gpu for training when available. Default is FALSE.}

\item{parallel}{logical. If TRUE, allow cpu parallel computing. Default is FALSE.}

\item{seed}{random generator seed.}
}
\value{
A list containing the following elements
    \item{seqs}{an object of class \code{"\link{proc}"} with \code{time_seqs=NULL}.}
    \item{weights}{a list containing the weights used for generating sequences.}
}
\description{
\code{seq_gen3} generates action sequences according to a recurrent neural network
}
\seealso{
Other sequence generators: \code{\link{seq_gen2}},
  \code{\link{seq_gen}}
}
\concept{sequence generators}
