% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covls.R
\name{print.procmod_corls}
\alias{print.procmod_corls}
\title{Print a procrustean Correlation Matrix.}
\usage{
\method{print}{procmod_corls}(x, ...)
}
\arguments{
\item{x}{a \code{procmod_corls}
object}

\item{...}{other parameters passed to other functions}
}
\description{
Print a procrustean Correlation Matrix.
}
\examples{
# Build Three matrices of 3 rows.
A <- simulate_matrix(10,3)
B <- simulate_matrix(10,5)
C <- simulate_correlation(B,10,r2=0.6)

# Computes the correlation matrix
data <- procmod_frame(A = A, B = B, C = C)
cls <- corls(data, nrand = 1000)

print(cls)

}
\seealso{
\code{\link[ProcMod]{corls}}
}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
