% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{nmds}
\alias{nmds}
\title{Project a distance matrix in a euclidean space (NMDS).}
\usage{
nmds(distances, maxit = 100, trace = FALSE, tol = 0.001, p = 2)
}
\arguments{
\item{distances}{a \code{\link[stats]{dist}} object or a
\code{\link[base]{matrix}}
object representing a distance matrix.}

\item{maxit}{The maximum number of iterations.}

\item{trace}{Logical for tracing optimization. Default \code{TRUE}.}

\item{tol}{convergence tolerance.}

\item{p}{Power for Minkowski distance in the configuration space.}
}
\value{
a numeric matrix with at most \code{n-1} dimensions, with
        \code{n} the number pf observations. This matrix defines the
        coordinates of each point in the orthogonal space.
}
\description{
Project a set of points defined by a distance matrix in
an eucleadean space using the Kruskal's Non-metric
Multidimensional Scaling. This function is mainly a simplified
interface on the \code{\link[MASS]{isoMDS}} function using as
much as possible dimensions to limit the stress. The aims of this
NDMS being only to project point in an orthogonal space therefore
without any correlation between axis. Because a non-metric method
is used no condition is required on the used distance.
}
\examples{
data(bacteria)
bacteria_rel_freq <- sweep(bacteria,
                           1,
                           rowSums(bacteria),
                           "/")
bacteria_hellinger <- sqrt(bacteria_rel_freq)
bacteria_dist <- dist(bacteria_hellinger)

project <- nmds(bacteria_dist)

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
