% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{pca}
\alias{pca}
\title{Project a set of points in a euclidean space (PCA).}
\usage{
pca(data, scale = FALSE)
}
\arguments{
\item{data}{a numeric matrix describing the points}

\item{scale}{a \code{logical} value indicating if the dimensions must be scaled
to force for every column that \code{sd=1}. \code{FALSE} by default.}
}
\value{
a numeric matrix with at most \code{n-1} dimensions, with
        \code{n} the number pf observations. This matrix defines the
        coordinates of each point in the orthogonal space.
}
\description{
Project a set of points defined by a set of numeric variables in
an eucleadean space using the pricipal componant analysis.
This function is mainly a simplified
interface on the \code{\link[stats]{prcomp}} function using as
much as possible dimensions to keep all the variation. The aims of this
PCA being only to project point in an orthogonal space therefore
without any correlation between axis. Data are centered by not scaled by
default.
}
\examples{
data(bacteria)
bacteria_rel_freq <- sweep(bacteria,
                           1,
                           rowSums(bacteria),
                           "/")
bacteria_hellinger <- sqrt(bacteria_rel_freq)

project <- pca(bacteria_hellinger)

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
