% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observed.R
\name{observed}
\alias{observed}
\title{Observed Run-Off Triangle Layout vs. Predicted (Unknown) Layout}
\usage{
observed(object, cum = TRUE)
}
\arguments{
\item{object}{either an integer value to denote the dimension of the run-off
triangle layout (i.e., the value that represents the number of origins (rows)
and also the number of the development periods (columns)). Alternatively,
a cumulatige or incremental run-off triangle (i.e, an object of the class
\code{matrix} or \code{triangle}) can be provided in \code{object}. In such
case the output returns the standard run-off triangle with \code{NA} values
in the lower-right triangular part of the matrix (regardless of wheter the
input triangle in \code{object} forms a run-off triangle or it is a fully
observed triangle---data matrix)}

\item{cum}{logical to indicate whether the output run-off triangle is supposed to
be of a cumulative type (\code{DEFAULT}) or an incremental type (\code{cum = FALSE}).
If the input in \code{object} is an integer value (i.e., the dimension of the
run-off triangle)  then the choice of the \code{cum} parameter is ignored}
}
\value{
If \code{object} is an integer value then the function returns
a TRUE/FALSE layout matrix with the \code{TRUE} values for the observed (known)
part of the run-off triangle (the upper-left triangular part of the matrix)
and values \code{FALSE} otherwise.  If \code{object} is a matrix (an object
of the class \code{matrix} or \code{triangle}) then the function returns the
observed (known) part of the run-off triangle with \code{NA} values elsewhere.
Depending on the choice of the \code{cum} parameter, either a cumulative
(\code{DEFAULT}) or incremental (\code{cum = FALSE}) run-off triangle is returned
}
\description{
Simple layout function to make work with (cumulative or incremental) run-off
triangles more easy and straightforward.
}
\examples{
print(observed(5))
print(!observed(5))

data(CameronMutual)
observed(CameronMutual)
observed(CameronMutual, cum = FALSE)

}
\seealso{
\code{\link[=plot.profileLadder]{plot.profileLadder()}}, \code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}
}
