% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_pert_demora.R
\name{delay.pert}
\alias{delay.pert}
\title{Problems of distribution of delay in deterministic projects}
\usage{
delay.pert(duration, precedence, observed.duration, delta = NULL)
}
\arguments{
\item{duration}{Vector with the expected duration for each activity.}

\item{precedence}{A matrix that indicates the order of precedence between activities. If the value \eqn{(i,j)} is equal to 1 then \eqn{i} precedes \eqn{j}.}

\item{observed.duration}{Vector with the observed duration for each activity.}

\item{delta}{Value to indicate the maximun time that the project can take without delay. If this value is not added, the function will use as delta the expected project time.}
}
\value{
The delay value and a solution matrix.
}
\description{
This function calculates the delay of a project once it has been completed. In addition, it also calculates the distribution of the delay between the different activities with the proportional, truncated proportional and Shapley rule.
}
\details{
Given a problem of sharing delays in a project \eqn{(N,\prec,\{\bar{X}_i\}_{i\in N},\{x_i\}_{i\in N})},  such that \eqn{\{\bar{X}_i\}_{i\in N}} is the expected value of activities' duration and \eqn{\{x_i\}_{i\in N}} the observed value. If \eqn{D(N,\prec,\{\bar{X}_i\}_{i\in N})} is the expected project time and \eqn{D(N,\prec,\{x_i\}_{i\in N})} is the observed project time, it has to \eqn{d=D(N,\prec,\{\bar{X}_i\}_{i\in N})-\delta>0} is the delay, where \eqn{\delta} can be any arbitrary value greater than zero. The following rules distribute the delay among the different activities.

The proportional rule, from \cite{Brânzei et al. (2002)}, distributes the delay, \eqn{d}, proportionally. So that each activity receives a payment of:
\deqn{\phi_i=\frac{\displaystyle x_{i}-\bar{X}_{i}}{\displaystyle \sum_{j\in N}\max\{x_{j}-\bar{X}_{j},0\}}\cdot d \qquad if  \qquad x_{i}-\bar{X}_{i}>0}
and 0  in another case.

The truncated proportional rule, from \cite{Brânzei et al. (2002)}, distributes the delay, \eqn{d}, proportionally, where the individual delay of each player is reduced to \eqn{d} if if is larger. So that each activity receives a payment of:
\deqn{\bar{\phi}_i=\frac{\displaystyle \min\{x_{i}-\bar{X}_{i},d\}}{\displaystyle \sum_{j\in N} \max\{\min\{x_{j}-\bar{X}_{j},d\},0\}}\cdot d \qquad if  \qquad x_{i}-\bar{X}_{i}>0}
and 0  in another case.

Shapley rule distributes the delay, \eqn{d}, based on the Shapley value for TU games, see \cite{Bergantiños et al. (2018)}. Given a project problem with delays \eqn{(N,\prec,\{\bar{X}_i\}_{i\in N},\{x_i\}_{i\in N})}, its associated TU game, \eqn{(N,v)}, is \eqn{v(S)=\max\{D(N,\prec,(\{\bar{X}_i\}_{i\in N\backslash S},\{x_i\}_{i\in S}))-\delta,0\}} for all \eqn{S\subseteq N}. If the number of activities is greater than nine, the Shapley value, of the game \eqn{(N,v)}, is estimated using a unique sampling process for all players, see \cite{Castro et al. (2009)}.
}
\examples{
precedence<-matrix(c(0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0),nrow=5,ncol=5,byrow=TRUE)
duration<-c(2,1,1,4,2)
observed.duration<-c(2.5,1.25,2,4.5,3)
delta<-6.5
delay.pert(duration,precedence,observed.duration,delta)
}
\references{
\describe{
  \item{}{Bergantiños, G., Valencia-Toledo, A., & Vidal-Puga, J. (2018). Hart and Mas-Colell consistency in PERT problems. Discrete Applied Mathematics, 243, 11-20.}
  \item{}{Brânzei, R., Ferrari, G., Fragnelli, V., & Tijs, S. (2002). Two approaches to the problem of sharing delay costs in joint projects. Annals of Operations Research, 109(1-4), 359-374.}
  \item{}{Castro, J., Gómez, D., & Tejada, J. (2009). Polynomial calculation of the Shapley value based on sampling. Computers & Operations Research, 36(5), 1726-1730.}
}
}
