% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_pert_calendario.R
\name{schedule.pert}
\alias{schedule.pert}
\title{Schedule for deterministic projects}
\usage{
schedule.pert(duration, precedence, PRINT = TRUE)
}
\arguments{
\item{duration}{Vector with the duración for each activity.}

\item{precedence}{A matrix that indicates the order of precedence between activities.  If the value \eqn{(i,j)} is equal to 1 then \eqn{i} precedes \eqn{j}.}

\item{PRINT}{Logical indicator to show the schedule represented in a graph (Default=TRUE)}
}
\value{
A list of a project schedule and if PRINT=TRUE a plot of schedule.
}
\description{
This function calculates the duration of the project, the slacks for each activity, as well as the schedule of each activity.
}
\examples{
precedence<-matrix(c(0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0),nrow=5,ncol=5,byrow=TRUE)
duration<-c(3,2,1,1.5,4.2)
schedule.pert(duration,precedence)
}
\references{
\describe{
  \item{}{Burke, R. (2013). Project management: planning and control techniques. New Jersey, USA.}
}
}
