% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_resource_leveling.R
\name{levelling.resources}
\alias{levelling.resources}
\title{Project resource levelling}
\usage{
levelling.resources(
  duration,
  prec1and2 = matrix(0),
  prec3and4 = matrix(0),
  resources,
  int = 1
)
}
\arguments{
\item{duration}{Vector with the duration for each activity.}

\item{prec1and2}{A matrix indicating the order of precedence type 1 and 2 between the activities (Default=matrix(0)). If value \eqn{(i,j)=1} then activity \eqn{i} precedes type \eqn{1} to \eqn{j}, and if \eqn{(i,j)=2} then activity \eqn{i} precedes type \eqn{2} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{prec3and4}{A matrix indicating the order of precedence type 3 and 4 between the activities (Default=matrix(0)). If value \eqn{(i,j)=3} then activity \eqn{i} precedes type \eqn{3} to \eqn{j}, and if \eqn{(i,j)=4} then activity \eqn{i} precedes type \eqn{4} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{resources}{Vector indicating the necessary resources for each activity per period of time.}

\item{int}{Numerical value indicating the duration of each period of time (Default=1).}
}
\value{
A solution matrices.
}
\description{
This function calculates the schedule of the project so that the consumption of resources is as uniform as possible.
}
\details{
The problem of leveling resources takes into account that in order for activities to be carried out in the estimated time, a certain level of resources must be used. The problem is to find a schedule that allows to execute the project in the estimated time so that the temporary consumption of resources is as level as possible.
}
\examples{

duration<-c(3,4,2,1)
resources<-c(4,1,3,3)
prec1and2<-matrix(c(0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0),nrow=4,ncol=4,byrow=TRUE)

levelling.resources(duration,prec1and2,prec3and4=matrix(0),resources,int=1)
}
\references{
\describe{
  \item{}{Hegazy, T. (1999). Optimization of resource allocation and leveling using genetic algorithms. Journal of construction engineering and management, 125(3), 167-175.}
}
}
