% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info_OC.R
\name{get_info_OC}
\alias{get_info_OC}
\title{Retrieve information about regional and theme codes for the Open Coesione dataset.}
\usage{
get_info_OC(info)
}
\arguments{
\item{info}{character. The argument can be set to \code{"region"} if the data to be downloaded are based on regional codes, or it can be set to \code{"theme"} if the data to be downloaded are based on project's theme.}
}
\value{
Return a vector of characters.
Regions:
\itemize{
\item{VDA \strong{=>} Valle d'Aosta}
\item{PIE \strong{=>} Piemonte}
\item{LOM \strong{=>} Lombardia}
\item{TN_BZ \strong{=>} Trentino Alto Adige (Bolzano)}
\item{VEN \strong{=>} Veneto}
\item{FVG \strong{=>} Friuli di Venezia Giulia}
\item{LIG \strong{=>} Liguria}
\item{EMR \strong{=>} Emilia Romagna}
\item{TOS \strong{=>} Toscana}
\item{UMB \strong{=>} Umbria}
\item{MAR \strong{=>} Marche}
\item{LAZ \strong{=>} Lazio}
\item{ABR \strong{=>} Abruzzo}
\item{CAM \strong{=>} Campania}
\item{MOL \strong{=>} Molise}
\item{PUG \strong{=>} Puglia}
\item{CAL \strong{=>} Calabria}
\item{BAS \strong{=>} Basilicata}
\item{SIC \strong{=>} Sicilia}
\item{SAR \strong{=>} Sardegna}
\item{NAZ \strong{=>} National Level}
\item{EST \strong{=>} Estero (Abroad)}
}

Themes:
\itemize{
\item{RICERCA_INNOVAZIONE \strong{=>} Research and Innovation}
\item{RETI_SERVIZI_DIGITALI \strong{=>} Digital Services}
\item{COMPETITIVITA_IMPRESE \strong{=>} Firms Competition}
\item{ENERGIA \strong{=>} Energy}
\item{AMBIENTE \strong{=>} Environment}
\item{CULTURA_TURISMO \strong{=>} Culture and Tourism}
\item{TRASPORTI" \strong{=>} Transports}
\item{OCCUPAZIONE \strong{=>} Employment}
\item{INCLUSIONE_SOCIALE_SALUTE \strong{=>} Social Inclusion and Health}
\item{ISTRUZIONE_FORMAZIONE \strong{=>} Education}
\item{CAPACITA_AMMINISTRATIVA \strong{=>} Administrative Capacity}
}
}
\description{
The \code{get_info_OC} function allows to get information regarding the codes to use to retrieve data from the Open Coesione database.
}
\details{
The information obtained can be used in the functions \code{get_data_OC} or \code{get_theme_OC}
}
\examples{
\donttest{get_info_OC("region")}


}
\references{
\href{https://opencoesione.gov.it/en/dati/}{Open Coesione}
}
\author{
Lorena Ricciotti
}
