% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_report.R
\name{generate_plate_report}
\alias{generate_plate_report}
\title{Generate a report for a plate.}
\usage{
generate_plate_report(
  plate,
  use_model = TRUE,
  filename = NULL,
  output_dir = "reports",
  counts_lower_threshold = 50,
  counts_higher_threshold = 70,
  additional_notes = NULL
)
}
\arguments{
\item{plate}{A plate object.}

\item{use_model}{(\code{logical(1)}) A logical value indicating whether the model should be used in the report.}

\item{filename}{(\code{character(1)}) The name of the output HTML report file.
If not provided or equals to \code{NULL}, the output filename will be based on the plate name, precisely: \verb{\{plate_name\}_report.html}.
By default the \code{plate_name} is the filename of the input file that contains the plate data.
For more details please refer to \link[PvSTATEM]{Plate}.

If the passed filename does not contain \code{.html} extension, the default extension \code{.html} will be added.
Filename can also be a path to a file, e.g. \code{path/to/file.html}. In this case, the \code{output_dir} and \code{filename} will be joined together.
However, if the passed filepath is an absolute path and the \code{output_dir} parameter is also provided, the \code{output_dir} parameter will be ignored.
If a file already exists under a specified filepath, the function will overwrite it.}

\item{output_dir}{(\code{character(1)}) The directory where the output CSV file should be saved.
Please note that any directory path provided will create all necessary directories (including parent directories) if they do not exist.
If it equals to \code{NULL} the current working directory will be used. Default is 'reports'.}

\item{counts_lower_threshold}{(\code{numeric(1)}) The lower threshold for the counts plots (works for each analyte). Default is 50.}

\item{counts_higher_threshold}{(\code{numeric(1)}) The higher threshold for the counts plots (works for each analyte). Default is 70.}

\item{additional_notes}{(\code{character(1)}) Additional notes to be included in the report. Contents of this fields are left to the user's discretion. If not provided, the field will not be included in the report.}
}
\value{
A report.
}
\description{
This function generates a report for a plate. The report contains all the necessary information about the plate, from the general plate parameters, such as examination date, to the breakdown of the analytes' plots.
The report is generated using the \code{plate_report_template.Rmd} template.
}
\examples{

plate_file <- system.file("extdata", "CovidOISExPONTENT_CO_reduced.csv", package = "PvSTATEM")
# a plate file with reduced number of analytes to speed up the computation
layout_file <- system.file("extdata", "CovidOISExPONTENT_CO_layout.xlsx", package = "PvSTATEM")
note <- "This is a test report.\n**Author**: Jane Doe \n**Tester**: John Doe"

plate <- read_luminex_data(plate_file, layout_file, verbose = FALSE)
example_dir <- tempdir(check = TRUE) # a temporary directory
generate_plate_report(plate,
  output_dir = example_dir,
  counts_lower_threshold = 40,
  counts_higher_threshold = 50,
  additional_notes = note
)
}
