% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PythonInR.R
\name{pyConnect}
\alias{pyConnect}
\title{connects R to Python}
\usage{
pyConnect(pythonExePath = NULL, dllDir = NULL, pythonHome = NULL)
}
\arguments{
\item{pythonExePath}{a character containing the path to "python.exe"
(e.g. "C:\\Python27\\python.exe")}

\item{dllDir}{an optional character giving the path to the dll file.
Since the dll file is normally in a system folder or in the same
location as python.exe, this parameter is \bold{almost never needed}!}

\item{pythonHome}{an optional character giving the path to PYTHONHOME.
On Windows by default PYTHONHOME is the folder where python.exe
is located, therefore this parameter is \bold{normally not needed}.}
}
\description{
Connects R to Python.
             \strong{(The parameters are only needed for the Windows version!)}
}
\details{
There is a different behavior for the static (Linux default)
         and the explicit linked (Windows default) version. Where as the
         static linked version automatically connects, when the package get's loaded,
         the explicitly linked version needs to be connected manually.
         More information can be found at the README file or at
         \url{http://pythoninr.bitbucket.org/}.
}
\examples{
\dontrun{
## Linux examples
pyConnect() # is done by default when the package is loaded

## Windows examples
pyConnect() ## will try to detect a suitable python version
            ## from the PATH given in the environment variables
pyConnect("C:\\\\Python27\\\\python.exe")

## One can also explicitly set the parameters for the connection.
PythonInR:::pyConnectWinDll(dllName="python27.dll", dllDir=NULL,
                            majorVersion=2, pythonHome="C:\\\\Python27",
                            pyArch="32bit")
}
}

