% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_section.R
\name{cross_section}
\alias{cross_section}
\title{Collect Cross-Section Google Trends Data}
\usage{
cross_section(params, geo = "", resolution = "COUNTRY")
}
\arguments{
\item{params}{A list containing parameters including keyword, topic, folder_name, start_date, end_date, and data_format.}

\item{geo}{Country/Region to collect data from. Defaults to Worldwide if empty.}

\item{resolution}{Resolution is a sub-region of the region selected for 'geo' ('COUNTRY', 'REGION', 'CITY', 'DMA'). Defaults to 'COUNTRY'.}
}
\value{
No return value, called for side effects.
}
\description{
This function uses the 'pytrends.interest_by_region()' function available in 'pytrends' Python library to collect cross-section Google Trends data and automatically store it in the specified directory.
}
\details{
This function collects Google Trends data based on the specified parameters and saves it in the following structure:
\code{folder_name/data_format/by_region}.
Each file contains data for a specific time period (day/week/month) and geographical region.
The filenames include the start and end dates of the data period.

PS: This method may take a long time to complete due to Google Trends API rate limits.
}
\examples{
\donttest{
# Please note that this example may take a few minutes to run
# Create a temporary folder for the example

# Ensure the temporary folder is cleaned up after the example

if (reticulate::py_module_available("pytrends")) {
  params <- initialize_request_trends(
    keyword = "Coronavirus disease 2019",
    topic = "/g/11j2cc_qll",
    folder_name = file.path(tempdir(), "test_folder"),
    start_date = "2024-05-01",
    end_date = "2024-05-03",
    data_format = "daily"
  )

  # Run the cross_section function with the parameters
  tryCatch({
    cross_section(params, geo = "US", resolution = "REGION")
  }, error = function(e) {
    message("An error occurred: ", e$message)
  })
  on.exit(unlink("test_folder", recursive = TRUE))
} else {
  message("The 'pytrends' module is not available.
  Please install it by running install_pytrendslongitudinalr()")
}
}

}
