% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATD.R
\name{momentATD}
\alias{momentATD}
\alias{meanATD}
\alias{varATD}
\alias{skewATD}
\alias{kurtATD}
\title{Moments estimation for the quantile-based asymmetric Student's-\eqn{t} distribution.}
\usage{
meanATD(mu, phi, alpha, nu)

varATD(mu, phi, alpha, nu)

skewATD(alpha, nu)

kurtATD(alpha, nu)

momentATD(phi, alpha, nu, r)
}
\arguments{
\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{nu}{This is the degrees of freedom parameter \eqn{\nu}, which must be positive.}

\item{r}{This is a value which is used to calculate the \eqn{r}th moment \eqn{(r\in\{1,2,3,4\})} about \eqn{\mu}.}
}
\value{
\code{\link{meanATD}} provides the mean, \code{\link{varATD}} provides the variance, \code{\link{skewATD}} provides the skewness, \code{\link{kurtATD}} provides the kurtosis, and  \code{\link{momentATD}} provides the \eqn{r}th moment about the location parameter \eqn{\mu} of the quantile-based asymmetric Student's-\eqn{t} distribution.
}
\description{
Mean, variance, skewness, kurtosis and moments about the location parameter (i.e., \eqn{\alpha}th quantile) of the quantile-based asymmetric Student's-\eqn{t} distribution defined in Gijbels et al. (2019a) useful for quantile regression with location parameter equal to \eqn{\mu}, scale parameter \eqn{\phi} and index parameter \eqn{\alpha}.
}
\examples{
# Example
meanATD(mu=0,phi=1,alpha=0.5,nu=10)
varATD(mu=0,phi=1,alpha=0.5,nu=10)
skewATD(alpha=0.5,nu=10)
kurtATD(alpha=0.5,nu=10)
momentATD(phi=1,alpha=0.5,nu=10,r=1)


}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
