% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAD.R
\name{LogLikGAD}
\alias{LogLikGAD}
\title{Log-likelihood function for the generalized quantile-based asymmetric family of distributions.}
\usage{
LogLikGAD(y, eta, phi, alpha, f, g)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{eta}{This is the location parameter \eqn{\eta}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{f}{This is the reference density function \eqn{f} which is a standard version of a unimodal and symmetric around 0 density.}

\item{g}{This is the "link" function. The function \eqn{g} is to be differentiated. Therefore, \eqn{g} must be written as a function. For example, {g<-function(y)\{log(y)\}} for log link function.}
}
\value{
\code{\link{LogLikGAD}} provides the realized value of the Log-likelihood function of the generalized quantile-based asymmetric family of distributions.
}
\description{
Log-Likelihood function \eqn{\ell_n(\eta,\phi,\alpha)=\ln[L_n(\eta,\phi,\alpha)]}
in the three parameter generalized quantile-based asymmetric family of densities defined in Gijbels et al. (2019b).
}
\examples{
# Example 1: Let F be a standard normal cumulative distribution function then
f_N<-function(s){dnorm(s, mean = 0,sd = 1)} # density function of N(0,1)
y<-rnorm(100)
g_id<-function(y){y}
g_log<-function(y){log(y)}
LogLikGAD(y,eta=0,phi=1,alpha=0.5,f=f_N,g=g_id) # For identity-link
LogLikGAD(rexp(100,0.1),eta=10,phi=1,alpha=0.5,f=f_N,g=g_log) # For log-link


# Example 2: Let F be a standard Laplace cumulative distribution function then
f_La<-function(s){0.5*exp(-abs(s))} # density function of Laplace(0,1)
LogLikGAD(y,eta=0,phi=1,alpha=0.5,f=f_La,g=g_id) # For identity-link
LogLikGAD(rexp(100,0.1),eta=10,phi=1,alpha=0.5,f=f_La,g=g_log) # For log-link
}
\references{
{


 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.
}
}
