% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_trial_data}
\alias{get_trial_data}
\title{Get the observations data of the current active trial}
\usage{
get_trial_data()
}
\value{
a data frame of the trial observations data
}
\description{
This function will retrieve the observations data of the current active trial
(i.e. including all studies within) as configured in the internal state
object using `set_trial()` function.
}
\examples{
if(interactive()) {
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# select a specific study/trial by name
set_trial("2018 PVT")

# select a specific environment/location dataset
set_study("2018 PVT Environment Number 1")

# retrive multi-environment trial data
MET <- get_trial_data()
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
