% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_pedigree_table}
\alias{get_pedigree_table}
\title{Get the Pedigree Table}
\usage{
get_pedigree_table(
  data,
  geno_column = "germplasmName",
  pedigree_column = "pedigree"
)
}
\arguments{
\item{data}{Germplasm dataset as a data.frame.}

\item{geno_column}{Name of the column that identifies the genotype/germplasm names.}

\item{pedigree_column}{Name of the column that identifies the pedigree strings.}
}
\value{
A data.frame with three columns corresponding to the identifiers for the individual,
female parent, and male parent, respectively. The row giving the pedigree of an
individual appears before any row where that individual appears as a parent.
Founders use NA in the parental columns.
}
\description{
Retrieve the pedigree table starting from the current germplasm list and associated
pedigree string that provides the parentage through which a cultivar was obtained.
}
\examples{
if (interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")

  # Select a specific study/trial by name
  set_trial("IDYT39")

  # Select a specific environment/location dataset
  set_study("IDYT39 Environment Number 9")

  # Retrieve the germplasm list of the selected environment/location
  germplasm <- get_germplasm_list()

  pedigree_table <- get_pedigree_table(germplasm, "germplasmName", "pedigree")

  #############################
  # nadiv package way
  # library(nadiv)

  # Get additive relationship matrix in sparse matrix format
  # A <- nadiv::makeA(pedigree_table)

  # Get A inverse matrix using base R function
  # AINV <- solve(as.matrix(A))

  #############################
  # ASReml-R package way
  # library(asreml)

  # Represent A inverse matrix in an efficient way using i, j index and Ainverse value
  # Actual genotype names of any given index are in the attr(ainv, "rowNames")
  # ainv <- asreml::ainverse(pedigree_table)

  #############################
  # Dummy data set for testing
  test <- data.frame(genotype = c("X", "Y"),
                     pedigree = c("A//B/D/2/C", "B/C/3/A//B/C/2/D"))

  pedigree_table <- get_pedigree_table(test, "genotype", "pedigree")
}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
