% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_trials}
\alias{list_trials}
\title{Get the List of Trials in the Current Active Breeding Program}
\usage{
list_trials(year = NULL)
}
\arguments{
\item{year}{The starting year to filter the list of trials (optional, default is NULL).}
}
\value{
A list of trials names.
}
\description{
Retrieves the trials list from the current active breeding program as configured 
in the internal state object using `set_program()` function.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")

  # List all studies/trials in the selected program
  list_trials()

  # Filter listed studies/trials by year
  list_trials(2022)
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
