% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gigwa.R
\name{gigwa_set_db}
\alias{gigwa_set_db}
\title{Set the Current Active GIGWA Database by Name}
\usage{
gigwa_set_db(db_name)
}
\arguments{
\item{db_name}{The name of the database to set as active.}
}
\value{
No return value. Updates the internal configuration with the selected database.
}
\description{
Select a GIGWA database as the active database for subsequent operations. This updates
the internal configuration object and resets any previously selected projects or runs.
}
\examples{
if (interactive()) {
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)
  gigwa_set_db("Sorghum-JGI_v1")
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_list_dbs}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
