## since rms does'nt has name space, we can not import the
## generic function Newlabels from it. Just define the generic
## function here.

##' Change labels of predictors
##'
##' This method function was written for competing risks regression
##' model for facilitating to change the labels of
##' predictors when construct a nomogram. It is used for the generic
##' function \code{\link[rms]{Newlabels}}
##' @title Change predictor labels for a model fit
##' @param fit a model fit
##' @param labels a character vector specifying new labels for variables in
##' a fit. To give new labels for all variables, you can specify labels of the
##' form labels=c("Age in Years","Cholesterol"), where the list of new labels
##' is assumed to be the length of all main effect-type variables in the fit
##' and in their original order in the model formula. You may specify a named
##' vector to give new labels in random order or for a subset of the variables,
##' e.g., labels=c(age="Age in Years",chol="Cholesterol")
##' @param ... other arguments
##' @return  a new model fit object with the levels adjusted.
##' @export
##' 
##' @keywords attributes
##'
##' @examples
##' 
##' data(prostate.dat)
##' dd <- datadist(prostate.dat)
##' options(datadist = "dd")
##' prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
##'            BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
##'            RACE_AA, data = prostate.dat,
##'            x = TRUE, y= TRUE, surv=TRUE,time.inc = 144)
##' prostate.crr <- crr.fit(prostate.f,cencode = 0,failcode = 1)
##' prostate.g <- Newlabels(
##'     prostate.crr,
##'     c(
##'         TX = 'Treatment options', 
##'         BX_GLSN_CAT = 'Biopsy Gleason Score Sum',
##'         CLIN_STG = 'Clinical stage'
##'     )
##' )
##'
Newlabels.cmprsk <- function(fit, labels, ...) {
    cph.f <- fit$cph.f
    fit$cph.f <- Newlabels(cph.f, labels = labels, ... = ...)
    fit
}
