% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cindex.R
\name{cindex}
\alias{cindex}
\title{Concordance Index Calculation (C-Index)}
\usage{
cindex(
  prob,
  fstatus,
  ftime,
  type = "crr",
  failcode = 1,
  cencode = 0,
  tol = 1e-20
)
}
\arguments{
\item{prob}{A risk score (typically a probability giving the risk of event failure)}

\item{fstatus}{The event status}

\item{ftime}{The event times. Applies when the \code{type} argument is \code{"survival"} or \code{"crr"}}

\item{type}{The outcome type: \code{"logistic"} for binary, \code{"survival"} for ordinary time-to-event, and \code{"crr"} for competing risks outcomes. Defaults to \code{"crr"}.}

\item{failcode}{The value of \code{fstatus} that indicates the event of interest. Defaults to \code{1}.}

\item{cencode}{The censoring event code. Defaults to \code{0}.}

\item{tol}{Error tolerance (not used)}
}
\value{
A named vector with following elements:
\item{N}{Total number of observations in the input data}
\item{n}{Number of observations used for calculation}
\item{usable}{Total number of usable pairs}
\item{concordant}{Number of concordant pairs}
\item{cindex}{The concordance index: number of concordant pairs divided by the total number of usable pairs}
}
\description{
Computes the concordance index for a predictor as a discrimination metric for binary, time-to-event, and competing risks outcomes.
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)

# Cross-validated predictions
prostate.dat$preds.cv.prostate.crr.120 <- tenf.crr(prostate.crr, time = 120, fold = 2)

## calculate the competing-risks version of concordance index
with(prostate.dat, cindex(preds.cv.prostate.crr.120,
                          ftime = TIME_EVENT,
                          fstatus =EVENT_DOD, type = "crr"))["cindex"]

}
\author{
Changhong Yu, Michael Kattan, Brian Wells, Amy Nowacki.
}
\keyword{regression}
\keyword{semiparametric}
