% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSTraj.R
\name{TSTraj}
\alias{TSTraj}
\title{Simulate two-dimensional stochastic differential equations}
\usage{
TSTraj(y0, time, deltat, x.rhs, y.rhs, parms = NA, sigma, lower.bound = NA,
  upper.bound = NA)
}
\arguments{
\item{y0}{the a two-element vector of the initial conditions for the state variables. Elements must be assigned as objects (see Example below).}

\item{time}{numeric value indicating the total time over which the simulation is to be run.}

\item{deltat}{numeric value indicating the frequency of stochastic perturbation, as \eqn{\Delta t}.}

\item{x.rhs}{A string containing the right hand side of the equation for x.}

\item{y.rhs}{A string containing the right hand side of the equation for y.}

\item{parms}{n-element vector of objects representing unvalued paramters in the equation. If parameter values are values in the equation, then default is \code{parms = NA}.}

\item{sigma}{numeric value specifying the noise intensity.}

\item{lower.bound}{numeric value specifying a lower bound in the simulation.}

\item{upper.bound}{numeric value specifying an upper bound in the simulation.}
}
\value{
returns a matrix with three columns (timestep, x values, and y values) with a legth of \code{time/deltat} (2*e4 in the examples below).
}
\description{
This function allows you to simulate two-dimensional stochastic differential equations.
}
\examples{
# First, the parameter values
	model.state <- c(x = 3, y = 3)
	model.sigma <- 0.2
	model.deltat <- 0.005
	model.time <- 100

# Second, write out the deterministic skeleton of the equations to be simulated
	equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0 + x*x)"

# Third, Run it

#Can also input x.rhs and y.rhs as strings that contain parameter names
#and include parms with names and values of parameters
model.parms <- c(alpha = 1.54, beta = 10.14, delta = 1, kappa = 1, gamma = 0.476, mu = 0.112509)
}
\keyword{Stochastic}
\keyword{simulation}

