% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleQp.R
\name{sampleQp}
\alias{sampleQp}
\title{Cluster-specific sample quantiles for clustered data}
\usage{
sampleQp(
  data,
  endpoint = "RECURRENCE",
  subjID = "PATIENT_ID",
  sampleID,
  Qpredictor = "Marker",
  probs = seq(from = 0.05, to = 0.95, by = 0.05),
  aggregate_sampleID_quantile = c("median", "mean", "min", "Q1", "Q3", "max"),
  ...
)
}
\arguments{
\item{data}{\link[base]{data.frame}}

\item{endpoint}{\link[base]{character} scalar, column name for the \link[survival]{Surv} endpoint}

\item{subjID}{\link[base]{character} scalar, column name for subject/patient ID}

\item{sampleID}{(optional) \link[base]{character} scalar,
column name for \code{sampleID}, which is nested within \code{subjID}.
When \code{sampleID} is missing, the analysis is performed with only one-level cluster of \code{subjID}}

\item{Qpredictor}{\link[base]{character} scalar, column name of the predictor variable}

\item{probs}{\link[base]{numeric} vector, probabilities of the \link[stats]{quantile}s}

\item{aggregate_sampleID_quantile}{\link[base]{character} vector, will be implemented in the next release}

\item{...}{additional parameters, currently not in use ..}
}
\value{
\link{sampleQp} returns
data set with one row per \code{subjID}, Np columns with Q(p), p=1,…, Np, and additional
subject level variables designated to be kept in the data set.
The code should allow for multiple clusters (\code{clusterID}) per subject (\code{subjID}) and output the
mean or other summary statistic (according to user input for type of summary statistic) Q(p) for
every p.
(*) Let us first make use of \link[base]{summary.default}, which cover all options I can think about for now
}
\description{
For a user-supplied sequence of percentiles, calculates sample quantiles in each independent cluster of observations.
}
\examples{
# see ?BBC_dichotom

}
