% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0splitSample_dichotom.R
\name{splitSample_dichotom}
\alias{splitSample_dichotom}
\title{Dichotomizing Split Sample}
\usage{
splitSample_dichotom(y, x, splitID, ...)
}
\arguments{
\item{y}{a \link[survival]{Surv} object, a \link[base]{logical} \link[base]{vector},
or a \link[base]{numeric} \link[base]{vector}, the endpoint}

\item{x}{\link[base]{numeric} \link[base]{vector}, the predictor}

\item{splitID}{a named length-2 \link[base]{list} of \link[base]{integer} \link[base]{vector}s,
the indexes of \code{'train'} and \code{'test'} set.}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{splitSample_dichotom} returns an object of S3 class \link{splitSample_dichotom},
which is essentially
a Cox proportional hazards (\link[survival]{coxph}),
or a logistic (\link[stats]{glm}),
or a linear (\link[stats]{lm})
regression model,
with three (3) additional \link[base]{attributes}

\describe{

\item{\code{attr(,'branch')}}{\link[base]{language} object,
the branch identified in the training set, via \link{rpartD}}

\item{\code{attr(,'highX')}}{\link[base]{numeric} scalar,
percentage of \code{x}, in the test set, which is greater than, or greater-than-or-equal-to,
the threshold represented in \code{attr(, 'branch')}}

\item{\code{attr(,'coef')}}{\link[base]{numeric} scalar,
the regression coefficient corresponding to the dichotomized \code{x} in the test set}

}
}
\description{
For a given predictor and a random sample split,
finds the optimal dichotomizing branch from the training set,
applies this branch to dichotomize the predictor in the test set,
and runs a regression analysis in the test set using the dichotomized predictor.
}
\details{
Given a sample split in \code{splitID},

\enumerate{

\item finds the optimal dichotomizing branch of endpoint \code{y}
using predictor \code{x}, via \link{rpartD}, in the training set

\item dichotomizes the predictor \code{x} using the branch identified in Step 1,
in the test set.
The dichotomized \code{x} is denoted as \code{TRUE}
if \code{x} is greater than, or greater-than-or-equal-to, the threshold
(see \link{rpartD}).

\item runs a regression model on the endpoint \code{y}
using the dichotomized predictor \code{x} in Step 2, in the test set.
Currently the Cox proportional hazards (\link[survival]{coxph}) regression for \link[survival]{Surv} endpoint,
logistic (\link[stats]{glm}) regression for \link[base]{logical} endpoint and
linear (\link[stats]{lm}) regression for \link[stats]{gaussian} endpoint
are supported.

}
}
\note{
\link[rpart]{rpart} in \link{rpartD} is the greatest computation cost in \link{splitSample_dichotom}.
}
