% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{Qindex_graphics}
\alias{Qindex_graphics}
\alias{persp.Qindex}
\alias{contour.Qindex}
\title{Visualize \linkS4class{Qindex} object using R package \pkg{graphics}}
\usage{
\method{persp}{Qindex}(
  x,
  n = 31L,
  xlab = "Percentages",
  ylab = "Quantiles",
  zlab = "Integrand of FR-index",
  ...
)

\method{contour}{Qindex}(
  x,
  n = 501L,
  image_col = topo.colors(20L),
  xlab = "Percentages",
  ylab = "Quantiles",
  ...
)
}
\arguments{
\item{x}{\linkS4class{Qindex} object}

\item{n}{\link[base]{integer} scalar, fineness of visualization,
default \code{501L}. See parameter \code{n.grid} of function \link[mgcv]{vis.gam}.}

\item{xlab, ylab}{\link[base]{character} scalars}

\item{zlab}{\link[base]{character} scalar, for function \link{persp.Qindex}}

\item{...}{..}

\item{image_col}{argument \code{col} of \link[graphics]{image.default}}
}
\value{
Function \link{persp.Qindex},
a method dispatch of S3 generic \link[graphics]{persp},
does not have a return value.

Function \link{contour.Qindex},
a method dispatch of S3 generic \link[graphics]{contour},
does not have a return value
}
\description{
Create \link[graphics]{persp}ective and \link[graphics]{contour}
plots of FR-index integrand using R package \pkg{graphics}.

End users are encouraged to use function \link{integrandSurface}
with \CRANpkg{plotly} work horse.
}
\keyword{internal}
