\name{plot.midquantile}
\alias{plot.midecdf}
\alias{plot.midquantile}

\title{
Plot Mid-distribution Functions
}
\description{
Plot an object generated by \code{\link{midecdf}} or \code{\link{midquantile}}.
}
\usage{
\method{plot}{midecdf}(x, ..., ylab = "p", main = "Ordinary and Mid-ECDF", verticals = FALSE,
	col.01line = "gray70", col.steps = "gray70", col.midline ="black", cex.points = 1,
	lty.midline = 2, lwd = 1, jumps = FALSE)
\method{plot}{midquantile}(x, ..., xlab = "p", ylab = "Quantile", main = "Ordinary and Mid-Quantiles",
	col.steps = "gray70", col.midline = "black", cex.points = 1, lty.midline = 2,
	lwd = 1, jumps = FALSE)
}

\arguments{
  \item{x}{
a \code{midecdf} or a \code{midquantile} object.
}
  \item{\dots}{
additional arguments for \code{\link{plot.default}}.
}
  \item{xlab}{
a label for the x axis.
}
  \item{ylab}{
a label for the y axis.
}
  \item{main}{
a main title for the plot.
}
  \item{verticals}{
logical. If \code{TRUE}, draw vertical lines at steps.
}
  \item{col.01line}{
numeric or character specifying the color of the horizontal lines at y = 0 and 1.
}
  \item{col.steps}{
the color for the steps of ordinary quantiles.
}
  \item{col.midline}{
the color for the mid-ecdf or the mid-quantile line.
}
  \item{cex.points}{
amount by which plotting characters and symbols should be scaled relative to the default. 
}
  \item{lty.midline}{
line type for the mid-ecdf or the mid-quantile line.
}
  \item{lwd}{
line width of the mid-ecdf or the mid-quantile line. 
}
  \item{jumps}{
logical flag. Should values at jumps be marked (with the convention that, at the point of discontinuity or 'jump', the function takes its value corresponding to the ordinate of the filled circle as opposed to that of the hollow circle)?
}


}


\author{
Marco Geraci
}


\seealso{
\code{\link{midecdf}}, \code{\link{midquantile}}
}

\keyword{print}
