% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{plot.pkbc}
\alias{plot.pkbc}
\alias{plot,pkbc,ANY-method}
\title{Plotting method for Poisson kernel-based clustering}
\usage{
\S4method{plot}{pkbc,ANY}(x, k = NULL, true_label = NULL, pca_res = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{pkbc}}

\item{k}{number of considered clusters. If it is not provided the scatter
plot is displayed for each value of number of clusters present in
the \code{x} object}

\item{true_label}{factor or vector of true membership to clusters (if
available). It must have the same length of final
memberships.}

\item{pca_res}{Logical. If TRUE the results from PCALocantore are also
reported (when dimension is greater than 3).}

\item{...}{Additional arguments that can be passed to the plot function}
}
\value{
The scatter-plot(s) and the elbow plot.
}
\description{
Plots for a pkbc object.
}
\details{
\itemize{
\item scatterplot: If dimension is equal to 2 or 3, points are displayed on the
circle and sphere, respectively. If dimension if greater than 3, the
spherical Principal Component procedure proposed by Locantore et al. (1999),
is applied for dimensionality reduction and the first three principal
components are normalized and displayed on the sphere. For d > 3, the
complete results from the \code{PcaLocantore} function (package \code{rrcov})
are returned if \code{pca_res=TRUE}.
\item elbow plot: the within cluster sum of squares (wcss) is computed using the
Euclidean distance (left) and the cosine similarity (right).
}
}
\note{
The elbow plot is commonly used as a graphical method for choosing the
\emph{appropriate} number of clusters. Specifically, plotting the wcss versus the
number of clusters, the suggested number of clusters correspond to the point
in which the plotted line has the greatest change in slope, showing
an elbow.
}
\examples{
dat<-matrix(rnorm(300),ncol=3)
pkbc_res<- pkbc(dat, 3)
plot(pkbc_res, 3)

}
\references{
Locantore, N., Marron, J.S., Simpson, D.G. et al. (1999) "Robust principal
component analysis for functional data." Test 8, 1–73.
https://doi.org/10.1007/BF02595862
}
\seealso{
\code{\link[=pkbc]{pkbc()}} for the clustering algorithm \cr
\linkS4class{pkbc} for the class object definition.
}
