% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wine.R
\docType{data}
\name{wine}
\alias{wine}
\title{Wine data set}
\format{
A data frame containing the following columns:
\itemize{
\item \code{Alcohol}
\item \code{Malic acid}
\item \code{Ash}
\item \code{Alcalinity of ash}
\item \code{Magnesium}
\item \code{Total phenols}
\item \code{Flavanoids}
\item \code{Nonflavanoid phenols}
\item \code{Proanthocyanins}
\item \code{Color intensity}
\item \code{Hue}
\item \code{OD280/OD315 of diluted wines}
\item \code{Proline}
\item \code{y}: class membership
}
}
\source{
Aeberhard, S. and Forina, M. (1991). Wine.
UCI Machine Learning Repository.
https://doi.org/10.24432/C5PC7J.
}
\usage{
wine
}
\description{
The \code{wine} data frame has 178 rows and 14 columns. The first 13
variables report 13 constituents found in each of the three types of wines.
The last column indicates the class labels (1,2 or 3).
}
\details{
These data are the results of a chemical analysis of wines grown in the same
region in Italy but derived from three different cultivars. The analysis
determined the quantities of 13 constituents found in each of the three types
of wines.
}
\examples{
data(wine)
summary(wine)

}
\references{
Aeberhard, S., Coomans, D. and De Vel, O. (1994). Comparative analysis of
statistical pattern recognition methods in high dimensional settings.
Pattern Recognition, 27(8), 1065-1077.
}
\keyword{datasets}
