% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QLMDp.R
\name{QLMDp}
\alias{QLMDp}
\title{Percentages used in Quantile Least Mahalanobis Distance estimation}
\usage{
QLMDp(
  p.lim = c(0.05, 0.95),
  p.N = 15L,
  equidistant = c("prob", "quantile"),
  p.extra = c(0.005, 0.01, 0.02, 0.03, 0.05, 0.95, 0.97, 0.98, 0.99, 0.995),
  obs,
  ...
)
}
\arguments{
\item{p.lim}{range of the equidistant (in probability or quantile) probabilities.  Default \code{c(.05, .95)}.}

\item{p.N}{non-negative 'integer' value, the number of the equidistant (in probability or quantile) probabilities. 
\code{p.N = 0L} indicates no equidistant probabilities are to be used.}

\item{equidistant}{'character' value, the type of equidistant probabilities to be used.
If \code{'prob'} (default), then the probabilities are equidistant.  
If \code{'quantile'}, then the quantiles (of the observations \code{obs}) corresponding to the probabilities are equidistant.}

\item{p.extra}{\strong{additional} probabilities to be used, default \code{c(.005, .01, .02, .03, .05, .95, .97, .98, .99, .995)}.}

\item{obs}{'numeric' vector of observations, only used when \code{equidistant = 'quantile'}}

\item{...}{additional parameters}
}
\value{
A vector of probabilities, corresponding to which the sample and theoretical quantiles are selected for 
minimizing the Mahalanobis distance (\code{\link{QLMDe}}). 
In practice, the length of this probability vector must be equal or larger than the number of parameters in the distribution model
to be estimated by \code{\link{QLMDe}}.
}
\description{
The vector of probabilities corresponding to sample and theoretical quantiles selected for 
minimizing the Mahalanobis distance (\code{\link{QLMDe}}) is determined by function \code{\link{QLMDp}}.
}
\details{
..
}
\examples{

(d2 = fmx('GH', A = c(1,6), B = 2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
set.seed(100); hist(x2 <- rfmx(n = 1e3L, dist = d2))
p_hist = geom_histogram(
  mapping = aes(x = x2, y = ..density..), 
  bins = 30L, colour = 'white', alpha = .1
)
  
(p1 = QLMDp()) # equidistant in probabilities
autoplot(d2, v = setNames(quantile(x2, probs = p1), nm = sprintf('\%.1f\%\%', 1e2*p1))) + p_hist

(p2 = QLMDp(equidistant = 'quantile', obs = x2)) # equidistnat in quantiles
autoplot(d2, v = setNames(quantile(x2, probs = p2), nm = sprintf('\%.1f\%\%', 1e2*p2))) + p_hist


}
