% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hoaglin_GH.R
\name{Hoaglin_GH}
\alias{Hoaglin_GH}
\title{Hoaglin's Letter-Value-Based method For Estimation of 
Tukey \eqn{g}-&-\eqn{h} distribution and its constrained versions (\eqn{g}-distribution, \eqn{h}-distribution)}
\usage{
Hoaglin_GH(
  x,
  p_g = seq.int(from = 0.15, to = 0.25, by = 0.005),
  p_h = seq.int(from = 0.15, to = 0.35, by = 0.005),
  halfSpread = c("full", "upper", "lower", "longer", "shorter"),
  ...
)
}
\arguments{
\item{x}{observations}

\item{p_g}{\code{FALSE} if the \eqn{g}-parameter is constrained at 0, otherwise probabilities used for estimating parameter `g`.}

\item{p_h}{\code{FALSE} if the \eqn{h}-parameter is constrained at 0, otherwise probabilities used for estimating parameter `h`}

\item{halfSpread}{\code{\link[base]{character}} scalar, which half-spread should be used}

\item{...}{additional parameters, currently not in use}
}
\value{
\code{\link{Hoaglin_GH}} returns a \code{\link[base]{double}} vector with element names \code{A}, \code{B}, \code{g} and \code{h}, 
indicating the parameters of a Tukey's \eqn{g}-&-\eqn{h} distribution.
}
\description{
\code{\link{Hoaglin_GH}} implements the letter-value-based method of estimating \code{g} and \code{h},
described in Hoaglin (2006), page 487, equation (33) (and the few lines beneath equation (33)).
}
\details{
\code{Hoaglin_GH} can replace the functionality of \code{fitdistrplus:::start.arg.default},
thus extend \code{\link[fitdistrplus]{fitdist}} for estimating Tukey's \eqn{g}-&-\eqn{h} distributions.

All page/formula numbers refer to Hoaglin (2006).
}
\examples{
set.seed(451); x = rGH(n = 1e2L, g = -.3, h = .1)
(y0 = Hoaglin_GH(x))

library(fitdistrplus)
fitdist(x, distr = 'GH', start = as.list.default(y0))

}
\references{
Hoaglin, D.C. (1006). Summarizing Shape Numerically: The \eqn{g}-and-\eqn{h} Distributions. 
In \emph{Exploring Data Tables, Trends, and Shapes} (eds D.C. Hoaglin, F. Mosteller and J.W. Tukey).
\doi{10.1002/9781118150702.ch11}
}
