% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx.R
\name{[,fmx,ANY,ANY,ANY-method}
\alias{[,fmx,ANY,ANY,ANY-method}
\title{Subset of Components in \code{\linkS4class{fmx}} and/or \code{\linkS4class{fmx_QLMDe}} Object}
\usage{
\S4method{[}{fmx,ANY,ANY,ANY}(x, i, j, drop)
}
\arguments{
\item{x}{\code{\linkS4class{fmx}} and/or \code{\linkS4class{fmx_QLMDe}} object}

\item{i}{\code{\link[base]{integer}} or \code{\link[base]{logical}} vector, 
the row index(es) of the subset of components to be chosen, see \code{\link[base]{[}}}

\item{j}{ignored (always \code{TRUE}, i.e., all parameters of such give distribution must be selected), see \code{\link[base]{[}}}

\item{drop}{ignored (always \code{FALSE}), see \code{\link[base]{[}}}
}
\value{
An \code{\linkS4class{fmx}} object consisting of a subset of components.
Note that subsetting \code{\linkS4class{fmx_QLMDe}} object will return an \code{\linkS4class{fmx}} object, 
which contains only the mixture parameters, i.e., information about the observations (e.g. slots \code{@data} and \code{@data.name}),
as well as other estimation related slots (e.g., \code{@init}) will be lost.
}
\description{
Taking subset of components in \code{\linkS4class{fmx}} and/or \code{\linkS4class{fmx_QLMDe}} object
}
\details{
Note that using definitions as S3 method dispatch \code{`[.fmx`} or \code{`[.fmx_QLMDe`} won't work 
for S4 objects \code{\linkS4class{fmx}} and/or \code{\linkS4class{fmx_QLMDe}}.
}
\examples{

(d = fmx('norm', mean = c(1, 5, 9)))
d[1:2, ]

}
