% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeManipulation.R
\name{UnshiftTree}
\alias{UnshiftTree}
\title{Add Tree to Start of List}
\usage{
UnshiftTree(add, treeList)
}
\arguments{
\item{add}{Tree to add to the list, of class \code{\link[ape:read.tree]{phylo}}.}

\item{treeList}{A list of trees, of class \code{list},
\code{\link[ape:multiphylo]{multiPhylo}},
or, if a single tree, \code{\link[ape:read.tree]{phylo}}.}
}
\value{
A list of class \code{list} or \code{multiPhylo} (following the
original class of \code{treeList}), whose first element is the tree specified
as \code{add}.
}
\description{
Add a tree to the start of a list of trees
}
\details{
This function is useful where the class of a list of trees is unknown.
Adding a tree to a multiPhylo object whose own attributes apply to all trees,
for example trees read from a nexus file, causes data to be lost.
}
\author{
Martin R. Smith
}
\keyword{internal}
