###########################################################################/**
# @RdocDefault findSourceTraceback
# 
# @title "Finds all 'srcfile' objects generated by source() in all call frames"
# 
# @synopsis
# 
# \description{
#   @get "title".  This makes it possible to find out which files are 
#   currently scripted by @see "base::source".
# }
# 
# \arguments{
#  \item{...}{Not used.}
# } 
#
# \value{
#   Returns a named list of objects of class 'srcfile'.
#   The names of the list entries corresponds to the 'filename'
#   value of each corresponding 'srcfile' object.
#   The returned list is empty if @see "base::source" was not called.
# }
# 
# @author
# 
# @keyword IO
# @keyword programming
#*/###########################################################################
setMethodS3("findSourceTraceback", "default", function(...) {
  argsToFind <- names(formals(base::source));

  srcfileList <- list();
  for (ff in sys.nframe():0) {
    env <- sys.frame(ff);
    exist <- sapply(argsToFind, FUN=exists, envir=env);
    if (!all(exist)) {
      next;
    }

    srcfile <- get("srcfile", envir=env);
    if (!is.null(srcfile)) {
      srcfileList <- c(srcfileList, list(srcfile));
    }
  } # for (ff ...)

  srcfileList <- unique(srcfileList);
  pathnames <- sapply(srcfileList, FUN=function(env) {
    get("filename", envir=env);
  });
  names(srcfileList) <- pathnames;

  srcfileList;
}) # findSourceTraceback()

############################################################################
# HISTORY:
# 2009-10-20
# o Created.
############################################################################
