% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcDT.R
\name{rbindDT}
\alias{rbindDT}
\title{Glueing, not merging, two data.table objects together, by matching column names}
\usage{
rbindDT(topDT, bottomDT)
}
\arguments{
\item{topDT}{data.table object 1. Its values will be placed at the top of the returned data.table object. This is an obligatory argument, without default value.}

\item{bottomDT}{data.table object 2. Its values will be placed at the bottom of the returned data.table object. This is an obligatory argument, without default value.}
}
\value{
The glued data.table object. Matching column names of 'topDT' and 'bottomDT' will be identified and its values will be placed in one column in the returned data.table object, the values of the 'topDT' argument on top of the values of the 'bottomDT' argument. Non-matching columns will be have missing values for the rows in the returned data.table object that correspond to the input data.table object in which the column name was not found.
}
\description{
Glueing, not merging, two data.table objects together, by matching column names
}
\examples{
library(data.table)
inputDT <- as.data.table(data.frame(x = seq(1, 20, 2), y = LETTERS[1:10], z = LETTERS[1:10]))
inputDT2 <- as.data.table(data.frame(p = seq(1, 40, 2), x = c(LETTERS[1:10], LETTERS[1:10]),
l = c(LETTERS[1:10], LETTERS[1:10]), m = c(LETTERS[1:10], LETTERS[1:10])))

rbindDT(inputDT, inputDT2)
}
